﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The pharmacy log controller.
    /// </summary>
    [Route("api/pharmacy-log")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class PharmacyLogController : BaseController
    {
        /// <summary>
        /// The pharmacy log service.
        /// </summary>
        private readonly IPharmacyLogService pharmacyLogService;

        /// <inheritdoc />
        public PharmacyLogController(IPharmacyLogService pharmacyLogService) => this.pharmacyLogService = pharmacyLogService;



        /// <summary>
        /// To fetch pharmacy logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of pharmacy logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of pharmacyLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("fetch-pharmacy-logs")]
        [ProducesResponseType(typeof(IEnumerable<PharmacyLogModel>), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> FetchAsync([FromBody] PharmacyLogFilterModel model)
        {
            model = (PharmacyLogFilterModel)EmptyFilter.Handler(model);
            var pharmacyLogs = await pharmacyLogService.FetchAsync(model);
            if (pharmacyLogs == null)
            {
                return ServerError();
            }

            return Success(pharmacyLogs);
        }

        /// <summary>
        /// To insert pharmacy logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of pharmacy logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of pharmacyLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("insert-pharmacy-logs")]
        [ProducesResponseType(500)]
        public async Task<int> InsertAsync([FromBody] PharmacyLogModel model)
        {
            model = (PharmacyLogModel)EmptyFilter.Handler(model);
            model.LogDate = DateTime.UtcNow;
            await pharmacyLogService.LogAsync(model);
            return 1;
        }
    }
}
